



<html>
<head>
  <title>javabog.dk -  - Arrays</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel7.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel9.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">8 <a name='afsn8'></a>Arrays</H1>
<P CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P CLASS="kapiteloversigt-western">Erkl&aelig;ring og brug af
  arrays.</P>
  <LI><P CLASS="kapiteloversigt-western">Arrays med startv&aelig;rdier.</P>
  <LI><P CLASS="kapiteloversigt-western">Arrays af objekter.</P>
  <LI><P CLASS="kapiteloversigt-western">Arrays sammenlignet med
  lister.</P>
</UL>
<P CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes ikke i
resten af bogen, men er nyttigt i praktisk programmering.</P>
<P CLASS="kapiteloversigt-western">Foruds&aelig;tter <a href='kapitel3.jsp'>kapitel 3</a>, Objekter
(og et enkelt sted <a href='kapitel5.jsp'>kapitel 5</a>, Nedarvning).</P>


<P CLASS="western" STYLE="">Ofte har man
behov for at h&aring;ndtere et st&oslash;rre antal objekter eller
simple typer p&aring; en ensartet m&aring;de. Hidtil har vi
gjort det med ArrayList, men Java underst&oslash;tter ogs&aring;
<I>arrays</I>.</P>
<BLOCKQUOTE CLASS="definition-western">Et array er en r&aelig;kke
data af samme type</BLOCKQUOTE>
<P CLASS="western">Man kan f.eks. have et array af int eller et array
af Point. N&aring;r man har et array af int, betyder det, at man
har en r&aelig;kke int-variabler, som ligger i arrayet og kan &aelig;ndres
eller l&aelig;ses vha. arrayet og et indeks. Indekset er nummeret p&aring;
variablen i arrayet - ligesom i ArrayList.</P>
<P CLASS="western">Ligesom med ArrayList skal man skelne mellem
array-variablen og array-objektet. Array-variablen refererer til
array-objektet, som indeholder variablerne.</P>
<H2 CLASS="western">8.1 <a name='afsn8.1'></a>Erkl&aelig;ring og brug</SPAN></H2>
<P CLASS="western">Man erkl&aelig;rer en array-variabel med den type
data, man &oslash;nsker at lave et array af, umiddelbart
efterfulgt af [ og ], f.eks.:</P>
<PRE CLASS="kode-western">    int[] arr;</PRE><P CLASS="western">
Dette erkl&aelig;rer, at arr er en variabel med typen &quot;array af
int&quot;. Ligesom med variabler af objekt-type er dette blot en
reference hen til det egentlige array-objekt. Hvis man &oslash;nsker
at oprette et array, skriver man f.eks.:</P>
<PRE CLASS="kode-western">    arr = new int[6];</PRE><P CLASS="western">
Dette s&aelig;tter arr til at referere til et array, der har 6
elementer.</P>
<P CLASS="western">Elementer i et array bliver altid initialiseret
med 0 som standardv&aelig;rdi<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>.
Arrayets v&aelig;rdier kan s&aelig;ttes og afl&aelig;ses ved at
angive indeks i firkantede []-parenteser efter variabelnavnet:</P>
<PRE CLASS="kode-western">public class ArrayEksempel1
{
  public static void main(String[] arg)
  {
<B>    int[] arr = new int[6];</B>
<B>    arr[0] = 28;</B>
    arr[2] = 13;

    arr[3] = arr[0] + arr[1] + arr[2];

    int l&aelig;ngde = <B>arr.length</B>;    <I>// = 6, da vi oprettede det med new int[6]</I>

    for (int i=0; i&lt;l&aelig;ngde; i=i+1) System.out.print( <B>arr[i]</B> + &quot; &quot; );
    System.out.println();
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">28 0 13 41 0 0</PRE><P CLASS="western">
Indekseringen starter altid fra 0 af og sidste lovlige indeks er lig
med arrayets l&aelig;ngde-1. Indekserer man uden for arrayets
gr&aelig;nser, kastes en ArrayIndexOutOfBoundsException.</P>
<P CLASS="western">Alle arrays er objekter (derfor bruges
new-operatoren, n&aring;r vi opretter et nyt array). Alle
array-objekter har variablen length, som fort&aelig;ller, hvor mange
pladser arrayet indeholder.</P>
<BLOCKQUOTE CLASS="definition-western">L&aelig;ngden p&aring; et
array kan ikke &aelig;ndres</BLOCKQUOTE>
<P CLASS="western">Selvom array-objekter ikke kan &aelig;ndre l&aelig;ngde,
kan man lade variablen referere til et andet array-objekt med en
anden l&aelig;ngde:</P>
<PRE CLASS="kode-western">    arr = new int[8];</PRE><P CLASS="western">
Nu refererer arr til et andet array med l&aelig;ngde 8.</P>
<H3 CLASS="western">8.1.1 <a name='afsn8.1.1'></a>Eksempel: Statistik</H3>
<P CLASS="western">Arrays er gode til at lave statistik med. Her
laver vi statistik p&aring; slag med to terninger:</P>
<PRE CLASS="kode-western">import java.util.*;

public class TerningStatistik
{
  public static void main(String[] arg)
  {
    int[] statistik = new int[13];    <I>// array med element nr. 0 til og med 12</I>

    for (int i=0; i&lt;100; i=i+1) 
    {
      int sum = (int) (6*Math.random()+1) + (int) (6*Math.random()+1);

      statistik[sum]=statistik[sum]+1; <I>// opt&aelig;l statistikken for summen af &oslash;jne</I>
    }

    for (int n=2; n&lt;=12; n=n+1) System.out.println( n + &quot;: &quot; + statistik[n]);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">2: 2
3: 9
4: 7
5: 17
6: 14
7: 15
8: 8
9: 9
10: 8
11: 7
12: 4</PRE><H3 CLASS="western">
8.1.2 <a name='afsn8.1.2'></a>Initialisere et array med startv&aelig;rdier</H3>
<P CLASS="western">Arrays kan initialiseres med startv&aelig;rdier i
{} og er adskilt med komma. Eksempel:</P>
<PRE CLASS="kode-western">    int[] arr = {28, 0, 13, 41, 0, 0};</PRE><P CLASS="western">
Det er ofte meget mere bekvemt end at s&aelig;tte de enkelte v&aelig;rdier.</P>
<P CLASS="western">Herunder et program, der udskriver antallet af
dage i hver m&aring;ned:</P>
<PRE CLASS="kode-western">public class Maaneder
{  
  public static void main(String[] arg)
  { 
<B>    int[] m&aring;nedesLgd = {31,28,31,30,31,30,31,31,30,31,30,31};</B>
    
    System.out.println(&quot;Januar har &quot; + <B>m&aring;nedesLgd</B>[0] + &quot; dage.&quot;);
    System.out.println(&quot;April har &quot; + <B>m&aring;nedesLgd</B>[3] + &quot; dage.&quot;);

    <I>// med ny for-l&oslash;kke i JDK 1.5, se <a href='kapitel3.jsp#afsn3.5.1'>afsnit 3.5.1</a>.</I>
    for (int lgd : <B>m&aring;nedesLgd</B>) System.out.print(lgd + &quot; &quot;);

<I>    // med traditionel for-l&oslash;kke i JDK 1.4 og f&oslash;r:</I>
<I>  //  for (int i=0;i&lt;<B>m&aring;nedesLgd</B>.length; i++) System.out.print(<B>m&aring;nedesLgd</B>[i]+&quot; &quot;);</I>

    System.out.println();
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Januar har 31 dage.
April har 30 dage.
31 28 31 30 31 30 31 31 30 31 30 31</PRE><P CLASS="western">
Bem&aelig;rk at den specielle for-each-l&oslash;kke n&aelig;vnt i
<a href='kapitel3.jsp#afsn3.5.1'>afsnit 3.5.1</a> ogs&aring; kan bruges p&aring; arrays.</P>

<H3 CLASS="western" STYLE="">8.1.3 <a name='afsn8.1.3'></a>Arrayet i
main()-metoden</H3>
<P CLASS="western">Metoden main(), som vi har defineret utallige
gange, har en parameter, som er et array af strenge. Dette array
indeholder kommandolinje-argumenter ved k&oslash;rsel af programmet.</P>
<PRE CLASS="kode-western">public class Kommandolinje 
{
  public static void main(<B>String[] arg</B>)
  { 
    System.out.println(<B>&quot;Antallet af argumenter er: &quot; + arg.length</B>);

    for (int i=0; i&lt; <B>arg.length</B>; i=i+1)
      System.out.println(&quot;Argument &quot;+i+&quot; er: &quot; + <B>arg[i]</B>);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Antallet af argumenter er: 3
Argument 0 er: x
Argument 1 er: y
Argument 2 er: z</PRE><P CLASS="western">
Programmet herover er k&oslash;rt fra kommandolinjen med &quot;java
Kommandolinje x y z&quot;.</P>
<H2 CLASS="western">8.2 <a name='afsn8.2'></a>Genneml&oslash;b og manipulering af array</SPAN></H2>
<P CLASS="western">Et array er faktisk et objekt, men det har ingen
metoder og kun &eacute;n variabel, nemlig length. Arrays kan ikke
&aelig;ndre st&oslash;rrelse og length er s&aring;ledes konstant. 
</P>
<P CLASS="western">Den eneste m&aring;de at f&aring; et array af en
anden st&oslash;rrelse er at oprette et andet array af den &oslash;nskede
st&oslash;rrelse og s&aring; kopiere det gamle indhold over i det nye
array, s&aring; arrays er ikke s&aelig;rlig rare hvis antallet af
elementer varierer.</P>
<P CLASS="western">Herunder ses, hvordan man kan fjerne et element
fra et array:</P>
<PRE CLASS="kode-western">public class FjernEtElement
{
  public static void main(String[] arg)
  {    
<I>    // Oprettelse og initialisering af array</I>
     <B>int[] a = new int[10]</B>;
    for (int n=0; n&lt;a.length; n=n+1) a[n]=n*10;

<I>    // Genneml&oslash;b og udskrivning af array   </I>
    System.out.print(&quot;a f&oslash;r: &quot;);
     for (int n=0; n&lt;a.length; n=n+1) System.out.print(a[n]+&quot; &quot;);
     System.out.println();

<I>    // Kopiering af array / udtagning af element</I>
    int fjernes=5;        <I>// Element nr 5 skal fjernes.</I>

    <B>int[] tmp=new int[9]</B>;<I> // Nyt array med 9 pladser</I>

<I>    // bem&aelig;rk at elementet der skal fjernes ikke kopieres</I>
    <B>for (int n=0; n&lt;fjernes; n=n+1) tmp[n]=a[n]</B>;

    <B>for (int n=fjernes+1; n&lt;a.length; n=n+1) tmp[n-1]=a[n]</B>;

    <B>a=tmp</B>;                <I>// Nu refererer a til det nye array med 9 elementer</I>

    System.out.print(&quot;a efter: &quot;);
    for (int n=0; n&lt;a.length; n=n+1) System.out.print(a[n]+&quot; &quot;);
    System.out.println();
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">a f&oslash;r: 0 10 20 30 40 50 60 70 80 90
a efter: 0 10 20 30 40 60 70 80 90</PRE><P CLASS="western">
Eksemplet ovenfor illustrerer de basale m&aring;der at manipulere
arrays p&aring;, men bem&aelig;rk, at ligesom der findes en lang
r&aelig;kke standardmetoder til at arbejde med lister (beskrevet i
<a href='kapitel3.jsp#afsn3.10.2'>afsnit 3.10.2</a>), findes der metoder til at arbejde med arrays, der g&oslash;r
livet meget nemmere.</P>
<P CLASS="western">Se javadokumentationen for klassen Arrays (i
pakken java.util) for mere information.</P>
<H2 CLASS="western" STYLE="">8.3 <a name='afsn8.3'></a>Array af
objekter</SPAN></H2>
<P CLASS="western">Et array af objekter oprettes p&aring; samme m&aring;de
som et array af simple typer:</P>
<PRE CLASS="kode-western">    Point[] pkt = new Point[10];</PRE><P CLASS="western">
Bem&aelig;rk: Arrayet indeholder en r&aelig;kke af referencer til
objekterne. Herover oprettes alts&aring; ingen punkter! Dvs. pkt[0],
pkt[1],...,pkt[9] er alle null.</P>
<P CLASS="western">Arrays kan bruges til at g&aring; fra tal til
v&aelig;rdier i et dom&aelig;ne. For eksempel konvertering af
m&aring;neders numre (1-12) til deres navne:</P>
<PRE CLASS="kode-western">public class MaanedersNavne
{
  public static void main(String[] arg) 
  {
<B>    String[] m&aring;neder = {&quot;januar&quot;, &quot;februar&quot;, &quot;marts&quot;, &quot;april&quot;, &quot;maj&quot;, &quot;juni&quot;,</B>
<B>      &quot;juli&quot;, &quot;august&quot;, &quot;september&quot;, &quot;oktober&quot;, &quot;november&quot;, &quot;december&quot; };</B>

    System.out.println(&quot;Den 1. m&aring;ned er &quot; + m&aring;neder[0] );
    System.out.println(&quot;Den 6. m&aring;ned er &quot; + m&aring;neder[5] );
    System.out.println(&quot;Den 10. m&aring;ned er &quot; + m&aring;neder[9] );  
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Den 1. m&aring;ned er januar
Den 6. m&aring;ned er juni
Den 10. m&aring;ned er oktober</PRE><P CLASS="western">
P&aring; samme m&aring;de som strenge kan andre slags objekter l&aelig;gges
i et array, f.eks. punkter:</P>
<PRE CLASS="kode-western">Point[] pkt = { new Point(100,100), new Point(110,90), new Point(10,10) };</PRE><H3 CLASS="western">
8.3.1 <a name='afsn8.3.1'></a>Polymorfi</H3>
<P CLASS="western">Ligesom med almindelige variabler kan elementer i
et array godt referere til nedarvinger.</P>
<PRE CLASS="kode-western"><I>// Bruger <SPAN STYLE="font-weight: medium">Terning.java og FalskTerning2.java fra <a href='kapitel4.jsp'>kapitel 4</a> og 5</SPAN></I>
public class Terninger
{
  public static void main(String[] arg) 
  {
<B>    Terning[] t = { new Terning(), new FalskTerning2(), new FalskTerning2() };</B>

    for (int i=0; i&lt;t.length; i++) t[i].kast();
  }
}</PRE><H2 CLASS="western">
8.4 <a name='afsn8.4'></a>Arrays versus lister (ArrayList)</SPAN></H2>
<P CLASS="western">Som det ses, er det umuligt at &aelig;ndre
st&oslash;rrelsen p&aring; et array, s&aring; det er besv&aelig;rligt
f.eks. at inds&aelig;tte eller slette elementer. Til geng&aelig;ld
kan arrays nemmere indeholde simple typer og man kan initialisere et
array p&aring; &eacute;n linje. Faktisk er ArrayList-klassen et array
i en indpakning, der g&oslash;r det nemmere at bruge. Hvad du v&aelig;lger
er op til dig selv.</P>
<P CLASS="western">En liste er god at bruge, n&aring;r:</P>
<UL>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">antallet
  af elementer kan &aelig;ndre sig</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">der
  er brug for at inds&aelig;tte og slette elementer l&oslash;bende.</P>
</UL>
<P CLASS="western">Et array er godt at bruge, n&aring;r:</P>
<UL>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">antallet
  af elementer er fast og man evt. kender v&aelig;rdierne p&aring;
  forh&aring;nd</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">man
  arbejder med simple typer som int og double</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">programmet
  skal v&aelig;re meget hurtigt.</P>
</UL>
<P CLASS="western">Der er desuden den fordel ved arrays, at de er
typesikre. Vi kan ikke komme til at l&aelig;gge v&aelig;rdier af
forkerte typer ind i et array - s&aring; stopper overs&aelig;tteren
os.</P>
<H2 CLASS="western" STYLE="">8.5 <a name='afsn8.5'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel8.jsp#afsn8.5">
  <input type='checkbox' name='vis' value='8.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='8.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">
8.6 <a name='afsn8.6'></a>Opgaver</SPAN></H2>
<OL>
  <LI><P CLASS="western">Lav et program, der simulerer kast med 6
  terninger. Der udf&oslash;res f.eks. 100 kast. Opt&aelig;l i et
  array hyppigheden af summen af &oslash;jenantallene.</P>
  <LI><P CLASS="western">Udvid programmet til at kunne lave statistik
  p&aring; kast med et vilk&aring;rligt antal terninger.</P>
  <LI><P CLASS="western">&AElig;ndr programmet, s&aring; man kan
  angive antallet af terninger p&aring; kommandolinjen.</P>
</OL>
<H2 CLASS="western" STYLE="">8.7 <a name='afsn8.7'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel8.jsp#afsn8.7">
  <input type='checkbox' name='vis' value='8.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='8.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
8.7.1 <a name='afsn8.7.1'></a>Flerdimensionale arrays</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel8.jsp#afsn8.7.1">
  <input type='checkbox' name='vis' value='8.7.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='8.7.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>For
  et array af boolean vil de have v&aelig;rdien false (j.v.f. afsnit
  2.11.2, De simple typer). Havde arrayet indeholdt (referencer til)
  objekter, var de blevet sat til null.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel7.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel9.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (82% af vrket).
</font>
<br>
nsker du at se de sidste 18% af dette vrk (199974 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
